/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.schematics.table;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.element.RenderElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.content.schematics.client.ClientSchematicLoader;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.Label;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.gui.widget.SelectionScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.schematics.table.SchematicTableBlockEntity;
import com.zurrtum.create.content.schematics.table.SchematicTableMenu;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import com.zurrtum.create.foundation.utility.CreatePaths;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_7225;
import net.minecraft.class_768;
import net.minecraft.class_8942;
import net.minecraft.class_9129;

@Environment(value=EnvType.CLIENT)
public class SchematicTableScreen
extends AbstractSimiContainerScreen<SchematicTableMenu> {
    private final class_2561 uploading = CreateLang.translateDirect("gui.schematicTable.uploading", new Object[0]);
    private final class_2561 finished = CreateLang.translateDirect("gui.schematicTable.finished", new Object[0]);
    private final class_2561 refresh = CreateLang.translateDirect("gui.schematicTable.refresh", new Object[0]);
    private final class_2561 folder = CreateLang.translateDirect("gui.schematicTable.open_folder", new Object[0]);
    private final class_2561 noSchematics = CreateLang.translateDirect("gui.schematicTable.noSchematics", new Object[0]);
    private final class_2561 availableSchematicsTitle = CreateLang.translateDirect("gui.schematicTable.availableSchematics", new Object[0]);
    protected AllGuiTextures background;
    private ScrollInput schematicsArea;
    private IconButton confirmButton;
    private IconButton folderButton;
    private IconButton refreshButton;
    private Label schematicsLabel;
    private ElementWidget renderedItem;
    private float progress;
    private float chasingProgress;
    private float lastChasingProgress;
    private List<class_768> extraAreas = Collections.emptyList();

    public SchematicTableScreen(SchematicTableMenu menu, class_1661 playerInventory, class_2561 title) {
        super(menu, playerInventory, title);
        this.background = AllGuiTextures.SCHEMATIC_TABLE;
    }

    public static SchematicTableScreen create(class_310 mc, MenuType<SchematicTableBlockEntity> type, int syncId, class_1661 inventory, class_2561 title, class_9129 extraData) {
        SchematicTableBlockEntity entity = (SchematicTableBlockEntity)SchematicTableScreen.getBlockEntity(mc, extraData);
        if (entity == null) {
            return null;
        }
        try (class_8942.class_11340 logging = new class_8942.class_11340(entity.method_71402(), com.zurrtum.create.Create.LOGGER);){
            class_11368 view = class_11352.method_71417((class_8942)logging, (class_7225.class_7874)extraData.method_56349(), (class_2487)extraData.method_10798());
            entity.readClient(view);
            SchematicTableScreen schematicTableScreen = (SchematicTableScreen)((Object)type.create(SchematicTableScreen::new, syncId, inventory, title, entity));
            return schematicTableScreen;
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return this.method_19355(mouseX, mouseY).filter(element -> element.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)).isPresent();
    }

    @Override
    protected void method_25426() {
        this.setWindowSize(this.background.getWidth(), this.background.getHeight() + 4 + AllGuiTextures.PLAYER_INVENTORY.getHeight());
        this.setWindowOffset(-11, 8);
        super.method_25426();
        Create.SCHEMATIC_SENDER.refresh();
        List<class_2561> availableSchematics = Create.SCHEMATIC_SENDER.getAvailableSchematics();
        int y = this.field_2800 + 2;
        this.schematicsLabel = new Label(this.field_2776 + 51, y + 26, class_5244.field_39003).withShadow();
        this.schematicsLabel.text = class_5244.field_39003;
        if (!availableSchematics.isEmpty()) {
            this.schematicsArea = new SelectionScrollInput(this.field_2776 + 45, y + 21, 139, 18).forOptions(availableSchematics).titled(this.availableSchematicsTitle.method_27662()).writingTo(this.schematicsLabel);
            this.method_37063(this.schematicsArea);
            this.method_37063(this.schematicsLabel);
        }
        this.confirmButton = new IconButton(this.field_2776 + 44, y + 56, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> {
            if (((SchematicTableMenu)this.field_2797).canWrite() && this.schematicsArea != null) {
                ClientSchematicLoader schematicSender = Create.SCHEMATIC_SENDER;
                this.progress = 0.0f;
                this.chasingProgress = 0.0f;
                this.lastChasingProgress = 0.0f;
                List<class_2561> availableSchematics1 = schematicSender.getAvailableSchematics();
                class_2561 schematic = availableSchematics1.get(this.schematicsArea.getState());
                schematicSender.startNewUpload(this.field_22787, schematic.getString());
            }
        });
        this.folderButton = new IconButton(this.field_2776 + 20, y + 21, AllIcons.I_OPEN_FOLDER);
        this.folderButton.withCallback(() -> class_156.method_668().method_672(CreatePaths.SCHEMATICS_DIR.toFile()));
        this.folderButton.setToolTip(this.folder);
        this.refreshButton = new IconButton(this.field_2776 + 206, y + 21, AllIcons.I_REFRESH);
        this.refreshButton.withCallback(() -> {
            ClientSchematicLoader schematicSender = Create.SCHEMATIC_SENDER;
            schematicSender.refresh();
            List<class_2561> availableSchematics1 = schematicSender.getAvailableSchematics();
            this.method_37066(this.schematicsArea);
            if (!availableSchematics1.isEmpty()) {
                this.schematicsArea = new SelectionScrollInput(this.field_2776 + 45, this.field_2800 + 21, 139, 18).forOptions(availableSchematics1).titled(this.availableSchematicsTitle.method_27662()).writingTo(this.schematicsLabel);
                this.schematicsArea.onChanged();
                this.method_37063(this.schematicsArea);
            } else {
                this.schematicsArea = null;
                this.schematicsLabel.text = class_5244.field_39003;
            }
        });
        this.refreshButton.setToolTip(this.refresh);
        this.method_37063(this.confirmButton);
        this.method_37063(this.folderButton);
        this.method_37063(this.refreshButton);
        this.extraAreas = ImmutableList.of((Object)new class_768(this.field_2776 + this.background.getWidth(), y + this.background.getHeight() - 40, 48, 48), (Object)new class_768(this.refreshButton.method_46426(), this.refreshButton.method_46427(), this.refreshButton.method_25368(), this.refreshButton.method_25364()));
        this.renderedItem = new ElementWidget(this.field_2776 + this.background.getWidth(), this.field_2800 + this.background.getHeight() - 40).showingElement((RenderElement)GuiGameElement.of(AllItems.SCHEMATIC_TABLE.method_7854()).scale(3.0f));
        this.method_37063(this.renderedItem);
    }

    @Override
    public void method_25432() {
        super.method_25432();
        this.renderedItem.getRenderElement().clear();
    }

    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.getWidth());
        int invY = this.field_2800 + this.background.getHeight() + 4;
        this.renderPlayerInventory(graphics, invX, invY);
        this.background.render(graphics, this.field_2776, this.field_2800);
        class_2561 titleText = ((SchematicTableBlockEntity)((SchematicTableMenu)this.field_2797).contentHolder).isUploading ? this.uploading : (((SchematicTableMenu)this.field_2797).method_7611(1).method_7681() ? this.finished : this.field_22785);
        graphics.method_51439(this.field_22793, titleText, this.field_2776 + (this.background.getWidth() - 8 - this.field_22793.method_27525((class_5348)titleText)) / 2, this.field_2800 + 4, -11513776, false);
        if (this.schematicsArea == null) {
            graphics.method_51439(this.field_22793, this.noSchematics, this.field_2776 + 54, this.field_2800 + 28, -2894893, true);
        }
        int width = (int)((float)AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.getWidth() * class_3532.method_16439((float)partialTicks, (float)this.lastChasingProgress, (float)this.chasingProgress));
        int height = AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.getHeight();
        graphics.method_25290(class_10799.field_56883, AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.location, this.field_2776 + 70, this.field_2800 + 59, (float)AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.getStartX(), (float)AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.getStartY(), width, height, 256, 256);
    }

    @Override
    protected void method_37432() {
        super.method_37432();
        boolean finished = ((SchematicTableMenu)this.field_2797).method_7611(1).method_7681();
        if (((SchematicTableBlockEntity)((SchematicTableMenu)this.field_2797).contentHolder).isUploading || finished) {
            if (finished) {
                this.progress = 1.0f;
                this.lastChasingProgress = 1.0f;
                this.chasingProgress = 1.0f;
            } else {
                this.lastChasingProgress = this.chasingProgress;
                this.progress = ((SchematicTableBlockEntity)((SchematicTableMenu)this.field_2797).contentHolder).uploadingProgress;
                this.chasingProgress += (this.progress - this.chasingProgress) * 0.5f;
            }
            this.confirmButton.field_22763 = false;
            if (this.schematicsLabel != null) {
                this.schematicsLabel.colored(-3351041);
                String uploadingSchematic = ((SchematicTableBlockEntity)((SchematicTableMenu)this.field_2797).contentHolder).uploadingSchematic;
                this.schematicsLabel.text = uploadingSchematic == null ? null : class_2561.method_43470((String)uploadingSchematic);
            }
            if (this.schematicsArea != null) {
                this.schematicsArea.field_22764 = false;
            }
        } else {
            this.progress = 0.0f;
            this.lastChasingProgress = 0.0f;
            this.chasingProgress = 0.0f;
            this.confirmButton.field_22763 = true;
            if (this.schematicsLabel != null) {
                this.schematicsLabel.colored(-1);
            }
            if (this.schematicsArea != null) {
                this.schematicsArea.writingTo(this.schematicsLabel);
                this.schematicsArea.field_22764 = true;
            }
        }
    }

    @Override
    public List<class_768> getExtraAreas() {
        return this.extraAreas;
    }
}

